<?php
include 'db.php'; 

session_start();

// Get user ID from the session
$user_id = $_SESSION['user_id'] ?? null;

if (!$user_id) {
    echo json_encode(["status" => "error", "message" => "User not logged in"]);
    exit;
}

$order_id = $_GET['order_id'] ?? null;

if (!$order_id) {
    echo json_encode(["status" => "error", "message" => "Order ID is required"]);
    exit;
}

$order_query = "
    SELECT * FROM orders 
    WHERE Order_id = '$order_id'  AND Delete_status = 0
";

$order_result = mysqli_query($conn, $order_query);
if (!$order_result || mysqli_num_rows($order_result) == 0) {
    echo json_encode(["status" => "error", "message" => "Order not found or you do not have permission to delete this order"]);
    exit;
}

$order = mysqli_fetch_assoc($order_result);
$invoice_id = $order['Invoice_id'];

$order_delete_query = "
    UPDATE orders 
    SET Delete_status = 1, Editor_id = '$user_id' 
    WHERE Order_id = '$order_id'
";

if (mysqli_query($conn, $order_delete_query)) {
    $order_data_delete_query = "
        UPDATE order_data 
        SET Delete_status = 1 
        WHERE Order_id = '$order_id'
    ";

    if (mysqli_query($conn, $order_data_delete_query)) {
        $invoice_delete_query = "
            UPDATE invoice 
            SET Delete_status = 1, Editor_id = '$user_id' 
            WHERE Invoice_id = '$invoice_id'
        ";

        if (mysqli_query($conn, $invoice_delete_query)) {
            $invoice_data_delete_query = "
                UPDATE invoice_data 
                SET Delete_status = 1 
                WHERE Invoice_id = '$invoice_id'
            ";

            if (mysqli_query($conn, $invoice_data_delete_query)) {
                echo json_encode([
                    "status" => "success",
                    "message" => "Order, invoice, and associated data marked as deleted successfully"
                ]);
            } else {
                echo json_encode(["status" => "error", "message" => "Failed to delete invoice data"]);
            }
        } else {
            echo json_encode(["status" => "error", "message" => "Failed to delete invoice"]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to delete order data"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Failed to delete order"]);
}
?>
